.module/RAM/ABS=0       FIRDEMO;

.include    <system.k>;

{******************************************************************************
 *
 *  Variables
 *
 ******************************************************************************}

.const      taps=255;

.var    coeffsTbl [5];
.init   coeffsTbl: ^fir1_coefs, ^fir1_coefs, ^fir2_coefs,
                                ^fir3_coefs, ^fir4_coefs;
{                  ^^^^^^^^^^ dummy for talk through }


.var/dm/ram/circ                rx_buf[3];      /* Status + L data + R data */
.var/dm/ram/circ                tx_buf[3];      /* Cmd + L data + R data    */
.var/dm/ram/circ                init_cmds[13];
.var/dm                         stat_flag;
.var/circ       data[taps];
.var            which_fir;
.var            voice_or_noise;
.var            seed_msw, seed_lsw;
.var            rndnum;

.var/pm/circ    fir1_coefs[taps];
.var/pm/circ    fir2_coefs[taps];
.var/pm/circ    fir3_coefs[taps];
.var/pm/circ    fir4_coefs[taps];
.init           fir1_coefs: <fir1.dat>;
.init           fir2_coefs: <fir2.dat>;
.init           fir3_coefs: <fir3.dat>;
.init           fir4_coefs: <fir4.dat>;


.init tx_buf:   0xc000, 0x0000, 0x0000; /* Initially set MCE        */

.init init_cmds:
        0xc002,     {
                        Left input control reg
                        b7-6: 0=left line 1
                              1=left aux 1
                              2=left line 2
                              3=left line 1 post-mixed loopback
                        b5-4: res
                        b3-0: left input gain x 1.5 dB
                    }
        0xc102,     {
                        Right input control reg
                        b7-6: 0=right line 1
                              1=right aux 1
                              2=right line 2
                              3=right line 1 post-mixed loopback
                        b5-4: res
                        b3-0: right input gain x 1.5 dB
                    }
        0xc288,     {
                        left aux 1 control reg
                        b7  : 1=left aux 1 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc388,     {
                        right aux 1 control reg
                        b7  : 1=right aux 1 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc488,     {
                        left aux 2 control reg
                        b7  : 1=left aux 2 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc588,     {
                        right aux 2 control reg
                        b7  : 1=right aux 2 mute
                        b6-5: res
                        b4-0: gain/atten x 1.5, 08= 0dB, 00= 12dB
                    }
        0xc680,     {
                        left DAC control reg
                        b7  : 1=left DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc780,     {
                        right DAC control reg
                        b7  : 1=right DAC mute
                        b6  : res
                        b5-0: attenuation x 1.5 dB
                    }
        0xc850,     {
                        data format register
                        b7  : res
                        b5-6: 0=8-bit unsigned linear PCM
                              1=8-bit u-law companded
                              2=16-bit signed linear PCM
                              3=8-bit A-law companded
                        b4  : 0=mono, 1=stereo
                        b0-3: 0=  8.
                              1=  5.5125
                              2= 16.
                              3= 11.025
                              4= 27.42857
                              5= 18.9
                              6= 32.
                              7= 22.05
                              8=   .
                              9= 37.8
                              a=   .
                              b= 44.1
                              c= 48.
                              d= 33.075
                              e=  9.6
                              f=  6.615
                       (b0) : 0=XTAL1 24.576 MHz; 1=XTAL2 16.9344 MHz
                    }
        0xc909,     {
                        interface configuration reg
                        b7-4: res
                        b3  : 1=autocalibrate
                        b2-1: res
                        b0  : 1=playback enabled
                    }
        0xca00,     {
                        pin control reg
                        b7  : logic state of pin XCTL1
                        b6  : logic state of pin XCTL0
                        b5  : master - 1=tri-state CLKOUT
                              slave  - x=tri-state CLKOUT
                        b4-0: res
                    }
        0xcc40,     {
                        miscellaneous information reg
                        b7  : 1=16 slots per frame, 0=32 slots per frame
                        b6  : 1=2-wire system, 0=1-wire system
                        b5-0: res
                    }
        0xcd00;     {
                        digital mix control reg
                        b7-2: attenuation x 1.5 dB
                        b1  : res
                        b0  : 1=digital mix enabled
                    }


{******************************************************************************
 *
 *  Interrupt vector table
 *
 ******************************************************************************}
        jump start;  rti; rti; rti;     {00: reset }
        rti;         rti; rti; rti;     {04: IRQ2 }
        rti;         rti; rti; rti;     {08: IRQL1 }
        rti;         rti; rti; rti;     {0c: IRQL0 }
        ar = dm(stat_flag);             {10: SPORT0 tx }
        ar = pass ar;
        if eq rti;
        jump next_cmd;
        jump input_samples;             {14: SPORT1 rx }
                     rti; rti; rti;
        rti;         rti; rti; rti;     {18: IRQE }
        rti;         rti; rti; rti;     {1c: BDMA }
        jump irq1isr;
                     rti; rti; rti;     {20: SPORT1 tx or IRQ1 }
        rti;         rti; rti; rti;     {24: SPORT1 rx or IRQ0 }
        rti;         rti; rti; rti;     {28: timer }
        rti;         rti; rti; rti;     {2c: power down }


{******************************************************************************
 *
 *  ADSP 2181 intialization
 *
 ******************************************************************************}
start:
        {   shut down sport 0 }
        ax0 = b#0000100000000000;   dm (System_Control_Reg) = ax0;

{   restores monitor timer handler. }
        i7 = 0x3fe8;
        ar = pm (i7, m7);               { px implicit }
        i7 = 0x28;
        pm (i7, m7) = ar;


        i5 = ^rx_buf;
        l5 = %rx_buf;
        i6 = ^tx_buf;
        l6 = %tx_buf;
        i3 = ^init_cmds;
        l3 = %init_cmds;

        m1 = 1;
        m5 = 1;


{================== S E R I A L   P O R T   #0   S T U F F ==================}
        ax0 = b#0000110011010111;   dm (SPORT0_Autobuf) = ax0;
            {   |||!|-/!/|-/|/|+- receive autobuffering 0=off, 1=on
                |||!|  ! |  | +-- transmit autobuffering 0=off, 1=on
                |||!|  ! |  +---- | receive m?
                |||!|  ! |        | m5
                |||!|  ! +------- ! receive i?
                |||!|  !          ! i5
                |||!|  !          !
                |||!|  +========= | transmit m?
                |||!|             | m5
                |||!+------------ ! transmit i?
                |||!              ! i6
                |||!              !
                |||+============= | BIASRND MAC biased rounding control bit
                ||+-------------- 0
                |+--------------- | CLKODIS CLKOUT disable control bit
                +---------------- 0
            }

        ax0 = 0;    dm (SPORT0_RFSDIV) = ax0;
            {   RFSDIV = SCLK Hz/RFS Hz - 1 }
        ax0 = 0;    dm (SPORT0_SCLKDIV) = ax0;
            {   SCLK = CLKOUT / (2  (SCLKDIV + 1) }
        ax0 = b#1000011000001111;   dm (SPORT0_Control_Reg) = ax0;
            {   multichannel
                ||+--/|!||+/+---/ | number of bit per word - 1
                |||   |!|||       | = 15
                |||   |!|||       |
                |||   |!|||       |
                |||   |!||+====== ! 0=right just, 0-fill; 1=right just, signed
                |||   |!||        ! 2=compand u-law; 3=compand A-law
                |||   |!|+------- receive framing logic 0=pos, 1=neg
                |||   |!+-------- transmit data valid logic 0=pos, 1=neg
                |||   |+========= RFS 0=ext, 1=int
                |||   +---------- multichannel length 0=24, 1=32 words
                ||+-------------- | frame sync to occur this number of clock
                ||                | cycle before first bit
                ||                |
                ||                |
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }
            {   non-multichannel
                |||!|||!|||!+---/ | number of bit per word - 1
                |||!|||!|||!      | = 15
                |||!|||!|||!      |
                |||!|||!|||!      |
                |||!|||!|||+===== ! 0=right just, 0-fill; 1=right just, signed
                |||!|||!||+------ ! 2=compand u-law; 3=compand A-law
                |||!|||!|+------- receive framing logic 0=pos, 1=neg
                |||!|||!+-------- transmit framing logic 0=pos, 1=neg
                |||!|||+========= RFS 0=ext, 1=int
                |||!||+---------- TFS 0=ext, 1=int
                |||!|+----------- TFS width 0=FS before data, 1=FS in sync
                |||!+------------ TFS 0=no, 1=required
                |||+============= RFS width 0=FS before data, 1=FS in sync
                ||+-------------- RFS 0=no, 1=required
                |+--------------- ISCLK 0=ext, 1=int
                +---------------- multichannel 0=disable, 1=enable
            }


        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels0) = ax0;
            {   ^15          00^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_TX_Channels1) = ax0;
            {   ^31          16^   transmit word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels0) = ax0;
            {   ^15          00^   receive word enables: channel # == bit # }
        ax0 = b#0000000000000111;   dm (SPORT0_RX_Channels1) = ax0;
            {   ^31          16^   receive word enables: channel # == bit # }


{============== S Y S T E M   A N D   M E M O R Y   S T U F F ==============}
        ax0 = b#0001100000000000;   dm (System_Control_Reg) = ax0;
            {   +-/!||+-----/+-/- | program memory wait states
                |  !|||           | 0
                |  !|||           |
                |  !||+---------- 0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !||            0
                |  !|+----------- SPORT1 1=serial port, 0=FI, FO, IRQ0, IRQ1,..
                |  !+------------ SPORT1 1=enabled, 0=disabled
                |  +============= SPORT0 1=enabled, 0=disabled
                +---------------- 0
                                  0
                                  0
            }



        ifc = b#00000011111111;         { clear pending interrupt }
        nop;


        icntl = b#00010;
            {     ||||+- | IRQ0: 0=level, 1=edge
                  |||+-- | IRQ1: 0=level, 1=edge
                  ||+--- | IRQ2: 0=level, 1=edge
                  |+---- 0
                  |----- | IRQ nesting: 0=disabled, 1=enabled
            }


        mstat = b#1000000;
            {     ||||||+- | Data register bank select
                  |||||+-- | FFT bit reverse mode (DAG1)
                  ||||+--- | ALU overflow latch mode, 1=sticky
                  |||+---- | AR saturation mode, 1=saturate, 0=wrap
                  ||+----- | MAC result, 0=fractional, 1=integer
                  |+------ | timer enable
                  +------- | GO MODE
            }





{******************************************************************************
 *
 *  ADSP 1847 Codec intialization
 *
 ******************************************************************************}

        {   clear flag }
        ax0 = 1;
        dm(stat_flag) = ax0;

        {   enable transmit interrupt }
        ena ints;
        imask = b#0001000000;
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }


        ax0 = dm (i6, m5);          { start interrupt }
        tx0 = ax0;

check_init:
        ax0 = dm (stat_flag);       { wait for entire init }
        af = pass ax0;              { buffer to be sent to }
        if ne jump check_init;      { the codec            }

        ay0 = 2;
check_aci1:
        ax0 = dm (rx_buf);          { once initialized, wait for codec }
        ar = ax0 and ay0;           { to come out of autocalibration }
        if eq jump check_aci1;      { wait for bit set }

check_aci2:
        ax0 = dm (rx_buf);          { wait for bit clear }
        ar = ax0 and ay0;
        if ne jump check_aci2;
        idle;

        ay0 = 0xbf3f;               { unmute left DAC }
        ax0 = dm (init_cmds + 6);
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;

        ax0 = dm (init_cmds + 7);   { unmute right DAC }
        ar = ax0 AND ay0;
        dm (tx_buf) = ar;
        idle;


        ifc = b#00000011111111;     { clear any pending interrupt }
        nop;


{   end codec initialization, begin filter demo initialization }


        i0=^data;       m0=1;   l0=taps;
        i2=^rndnum;     m2=0;   l2=0;
        i4=^fir2_coefs; m4=1;   l4=taps;
        si=0;
        dm(which_fir)=si;       { start with no filtering of input signal }
        dm(voice_or_noise)=si;  { start with voice input, not noise input }
        si=h#1234;
        dm(seed_lsw)=si;        { arbitrary seed for random noise generator }
        dm(seed_msw)=si;
        i0=^data;

        cntr=taps;
        do zero until ce;
zero:       dm(i0,m0)=0;        { clear out the filter delay line buffer }
        {    if not ce jump zero;}

        imask = b#0000100101;       { enable rx0 interrupt }
            {     |||||||||+ | timer
                  ||||||||+- | SPORT1 rec or IRQ0
                  |||||||+-- | SPORT1 trx or IRQ1
                  ||||||+--- | BDMA
                  |||||+---- | IRQE
                  ||||+----- | SPORT0 rec
                  |||+------ | SPORT0 trx
                  ||+------- | IRQL0
                  |+-------- | IRQL1
                  +--------- | IRQ2
            }

        jump iSend;         {   send dummy to signal ready }

{------------------------------------------------------------------------------
 -
 -  command loop.
 -
 ------------------------------------------------------------------------------}
again:  { any thing from host ?}
        ar = dm (CHAR_WAITING_FLAG);            { kbhit () }
        none = pass ar;
        if ne jump again;

{ has something }
        i7 = dm (PTR_TO_GET_CHAR);        { get int }
        call (i7);
        if lt jump again; { time out }
        ay0 = 48;   { '0' }
        none = ax1 - ay0;
        if lt jump cmd1;
        ay0 = 57;   { '9' }
        none = ax1 - ay0;
        if le jump newfir;      { jump on '0'..'9' }
cmd1:   ay0 = 90;   { 'Z' }
        none = ax1 - ay0;
        if eq rts;          { go back to monitor. }
        ar = ax1 + 1;
        ax1 = ar;
iSend:  i7 = dm (PTR_TO_OUT_CHAR);        { send int }
        call (i7);

{ wait for char to go out }
wt:
        ar = dm (CHAR_SEND_DONE_FLAG);
        none = pass ar;
        if eq jump wt;

        toggle fl1;
        jump again;


newfir:
        {   default to no noise }
        ar = pass 0;
        dm(voice_or_noise) = ar;

        {   0 - no, 1-4 == fir1-4; + 5 for noise input }
        ay0 = 53;   { '5' }
        none = ax1 - ay0;
        if lt jump newfir1;

        ar = pass 1;
        dm(voice_or_noise) = ar;

        ay0 = 5;
        ar = ax1 - ay0;
        ax1 = ar;               { the rest same as mic }
newfir1:
        ay0 = 48;   { '0' }
        ar = ax1 - ay0;         { get actual filter number: 0..4 }
        dm(which_fir)=ar;

        { set i4 }
        ay0 = ^coeffsTbl;
        ar = ar + ay0;
        i7 = ar;
        ar = dm (i7, m7);
        i4 = ar;

        { return 'z' as ack. }
        ax1 = 122; { 'z' }
        jump iSend;





{------------------------------------------------------------------------------
 -
 -  SPORT0 interrupt handler
 -
 ------------------------------------------------------------------------------}

input_samples:
        ena sec_reg;                { use shadow register bank }

        ar=dm(voice_or_noise);
        ar=pass ar;
        if eq jump voice_input;

noise_input:
        call getrnd;                { generate a 16-bit random number in sr1 }
        sr=ashift sr1 by -1 (hi);   { save the audience's ears from damage }
        jump process_sample;

voice_input:
        sr1 = dm (rx_buf + 2); { get new sample from SPORT0 (from codec) }

process_sample:
        dm(i0,m0)=sr1;      { store sample in data buffer (delay line) }
        ar=dm(which_fir);  { decide which filter to do }
        none = pass ar;
        if ne jump fir;

nofilt: {sr=ashift sr1 by -1 (hi);}   { save the audience's ears from damage }
        mr1=sr1;
output:
        dm (tx_buf + 1) = mr1;      { filtered output to SPORT (to spkr) }
        dm (tx_buf + 2) = mr1;      { filtered output to SPORT (to spkr) }
        rti;

fir:    cntr=taps-1;
        mr=0, mx0=dm(i0,m0), my0=pm(i4,m4);
        do fir1loop until ce;
fir1loop:   mr=mr+mx0*my0(ss), mx0=dm(i0,m0), my0=pm(i4,m4);
        {    if not ce jump fir1loop;}
        mr=mr+mx0*my0(rnd);
        if mv sat mr;
        sr = ashift mr1 by 1 (lo);  {amplify filtered signal by 2 }
        mr1 = sr0;
        jump output;

getrnd:                           { random 16-bit value in sr1 }
        sr1=dm(seed_msw);
        sr0=dm(seed_lsw);
        my1=25;                                 { Upper half of a }
        my0=26125;                              { Lower half of a }
        dm(i2,m2)=sr1, mr=sr0*my1(uu);              { a(hi) X x(lo) }
        mr=mr+sr1*my0(uu);          { a(hi) X x(lo) + a(lo) X x(hi) }
        si=mr1;
        mr1=mr0;
        mr2=si;
        mr0=h#fffe;                     { c=32767, left-shifted by 1 }
        mr=mr+sr0*my0(uu);              {(above) + a(lo) X x(lo) + c }
        sr=ashift mr2 by 15 (hi);
        sr=sr or lshift mr1 by -1 (hi); { right-shift by 1 }
        sr=sr or lshift mr0 by -1 (lo);
        dm(seed_msw)=sr1;
        dm(seed_lsw)=sr0;
        rts;                            { random 16-bit value in sr1 }

{------------------------------------------------------------------------------
 -
 -  transmit interrupt used for Codec initialization
 -
 ------------------------------------------------------------------------------}
next_cmd:
        ena sec_reg;
        ax0 = dm (i3, m1);          { fetch next control word and }
        dm (tx_buf) = ax0;          { place in transmit slot 0    }
        ax0 = i3;
        ay0 = ^init_cmds;
        ar = ax0 - ay0;
        if gt rti;                  { rti if more control words still waiting }
        ax0 = 0xaf00;               { else set done flag and }
        dm (tx_buf) = ax0;          { remove MCE if done initialization }
        ax0 = 0;
        dm (stat_flag) = ax0;       { reset status flag }
        rti;


{******************************************************************************
 *  A high to low transition on flag_in signifies the start bit; it also
 *  triggers IRQ1 ISR which then turn on timer if the timer is off.  This is
 *  at to most 1/3 bit period too late but we shoudl still catch the byte.
 ******************************************************************************}
irq1isr:
        pop sts;
        ena timer;              { start timer now }
        rts;                    { note rts }

.endmod;
